<?php

/**
 * Dragonbyte-Tech.com Downloads Mod 1.0.0
 * 
 * @author David Tobin
 * @copyright 2010
 * @version 1.0
 * 
 * You may not copy/reproduce any part of this file in whole or significant part.
 * 
 * All rights reserved.
 */

class downloadModule_Pro extends downloadModule {
	
	public function __construct($registry) {
		parent::__construct($registry);
	}
	
	public function zip_it_up() {
		if ($this->registry->options['dbtech_downloads_zip_download'] == true) {
			$groupid = $this->registry->input->clean_gpc('g', 'fileid', TYPE_INT);
			
			$this->groupid = $groupid;
			
			$files = $this->registry->db->query_read("
				SELECT g.*, f.* FROM " . TABLE_PREFIX . "dbtech_downloads_filegroup AS g
				LEFT JOIN " . TABLE_PREFIX . "dbtech_downloads_fileinfo AS f ON (g.groupid = f.parentid)  
				WHERE f.parentid = " . intval($groupid) . "
			");
			
			if ($this->registry->db->num_rows($files) > 0) {
				$zip = new ZipArchive();
				
				$filename 	= $this->registry->options['dbtech_downloads_zip_prefix'];
				$zipname 	= $this->registry->options['dbtech_downloads_path_to_downloads'] . '/' . TIMENOW . '.zip';
				
				if ($zip->open($zipname, ZipArchive::CREATE) !== true) {
					die('Cannot create zip');
				} else {
					$i = 0;
					while ($file = $this->registry->db->fetch_array($files)) {
						if (file_exists($this->registry->options['dbtech_downloads_path_to_downloads'] . '/' . $file['fileid'] . '-' . $file['filename'])) {
							$zip->addFile($this->registry->options['dbtech_downloads_path_to_downloads'] . '/' . $file['fileid'] . '-' . $file['filename'], $file['filename']);					
						}
						
						if ($i == 0) {
							$filename .= str_replace(' ', '_', $file['groupname']) . '_' . TIMENOW . '.zip';
							$i++;
						}
					}
					
					($hook = vBulletinHook::fetch_hook('dbtech_downloads_module_download_zip_preclose')) ? eval($hook) : false;
					
					
					$zip->close();
					
					$this->filesize = filesize($zipname);
					
					$filedata = file_get_contents($zipname);
					unlink($zipname);
					
					if ($this->groupperm['downloads_per_day'] != 0 && $this->registry->userinfo['dbtech_downloads_downloads_today'] >= $this->groupperm['downloads_per_day']) {
						Downloads::throw_error('dbtech_downloads_downloads_quota_reached');
					}
					
					if ($this->groupperm['download_size_per_day'] != 0 && $this->registry->userinfo['dbtech_downloads_download_size_today'] >= $this->groupperm['download_size_per_day']) {
						Downloads::throw_error('dbtech_downloads_size_quota_reached');
					}
					
					if ($this->groupperm['download_size_per_day'] != 0 && $this->registry->userinfo['dbtech_downloads_download_size_today'] >= $this->groupperm['download_size_per_day'] + $this->filesize) {
						Downloads::throw_error('dbtech_downloads_size_quota_would_be_reached');
					}
					
					$this->output_data($filedata, $filename, 'application/zip', array('groupid' => $groupid, 'fileid' => $file['fileid']));
					exit;
				}
			}
		} else {
			print_no_permission();
		}
	}
}